#include <p30fxxxx.h>
#include <outcompare.h>

/* This devices support OutputCompare 5 thru OutputCompare 8 */
#if defined(__dsPIC30F6010__) || defined(__dsPIC30F5011__) || defined(__dsPIC30F6011__) || \
    defined(__dsPIC30F6012__) || defined(__dsPIC30F5013__) || defined(__dsPIC30F6013__) || \
    defined(__dsPIC30F6014__)

/********************************************************************
*    Function Name:  ReadDCOC6PWM                                   *
*    Description:    This routine reads duty cycle from Secondary   *
*                    register  in PWM mode                          *
*    Parameters:     None                                           *
*    Return Value:   unsigned int:duty cycle from Secondary register*
********************************************************************/

unsigned int ReadDCOC6PWM()
{
    /* check if OC is in PWM Mode */
    if((OC6CONbits.OCM & 0x06) == 0x06)
    {       
        return OC6RS; /* Output Compare Secondary Register */
    }
    else 
        return -1;
}

#endif
